Attribute VB_Name = "modUserlist"
Option Explicit

Public Minute_Ban_List()    As MBL
Private Type MBL
    Username                As String
    Minute_Ban_Tick         As Long
    Minute_Ban_Duration     As Integer
End Type

Public UserList()           As USL
Private Type USL
    Username                As String
    Ping                    As Long
    Flags                   As Long
    Product                 As String
    FILETIME                As Long
    Last_Message            As String
    Last_Message_2          As String
    Idle_Time               As Long
    Idle_Time_2             As Long
    Idle_Ban_Tick           As Long 'Resets when idle ban is turned on
    Access                  As String
End Type

Private Sub Class_Terminate()
    ReDim UserList(0)
End Sub

Public Sub Reset_UL()
    ReDim UserList(0)
End Sub

Public Sub Add_UL(ByVal Username As String, ByVal Ping As Long, ByVal Flags As Long, Optional ByVal Client As String, Optional ByVal Message As String, Optional ByVal SetIdleTime As Boolean)
Dim Index As Integer
Index = Index_UL(Username)
If Index > -1 Then 'Found
    UserList(Index).Username = Username
    UserList(Index).FILETIME = Get_FILETIME
    If Client <> vbNullString Then
        UserList(Index).Product = UCase$(StrReverse(Client))
    End If
    UserList(Index).Ping = Ping
    If Message <> vbNullString Then
        UserList(Index).Last_Message = Message
        If StrComp(Message, UserList(Index).Last_Message, vbTextCompare) = 0 Then
            UserList(Index).Last_Message_2 = Message
        End If
    End If
    If Message <> vbNullString Or SetIdleTime = True Then
        UserList(Index).Idle_Time_2 = UserList(Index).Idle_Time
        UserList(Index).Idle_Time = GetTickCount
        UserList(Index).Idle_Ban_Tick = GetTickCount
    End If
    UserList(Index).Flags = Flags
    UserList(Index).Access = ReconvertAccess(Flag_DB(Username, User))
    
Else 'Not Found
    UserList(UBound(UserList)).Username = Username
    UserList(UBound(UserList)).FILETIME = Get_FILETIME
    If Client <> vbNullString Then
        UserList(UBound(UserList)).Product = UCase$(StrReverse(Client))
    End If
    UserList(UBound(UserList)).Ping = Ping
    If Message <> vbNullString Then
        UserList(UBound(UserList)).Last_Message = Message
        If StrComp(Message, UserList(UBound(UserList)).Last_Message, vbTextCompare) = 0 Then
            UserList(UBound(UserList)).Last_Message_2 = Message
        End If
    End If
    UserList(UBound(UserList)).Idle_Time_2 = GetTickCount
    UserList(UBound(UserList)).Idle_Time = GetTickCount
    UserList(UBound(UserList)).Idle_Ban_Tick = GetTickCount
    UserList(UBound(UserList)).Flags = Flags
    UserList(UBound(UserList)).Access = ReconvertAccess(Flag_DB(Username, User))
    ReDim Preserve UserList(UBound(UserList) + 1)
End If
End Sub

Public Sub Remove_UL(ByVal Index As Integer)
Dim i As Integer
If Index - 1 > UBound(UserList) Then Exit Sub
For i = Index To UBound(UserList) - 1
      UserList(i) = UserList(i + 1)
Next i
ReDim Preserve UserList(UBound(UserList) - 1)
End Sub

Public Function Index_UL(ByVal Username As String) As Integer
Dim i As Integer
For i = 0 To UBound(UserList) - 1
    If StrComp(UserList(i).Username, Username, vbTextCompare) = 0 Then
        Index_UL = i
        Exit Function
    End If
Next i
Index_UL = -1
End Function

Public Sub ChannelCheck_UL()
    Dim i As Integer
    For i = 0 To UBound(UserList) - 1
        If (Flag_DB(UserList(i).Username, User) And DB_Flag_B) = DB_Flag_B Then
            Ban UserList(i).Username, "Auto-Ban"
        ElseIf (Flag_DB(UserList(i).Username, User) And DB_Flag_P) = DB_Flag_P Then
            Ban UserList(i).Username, "Auto-IPBan"
            If Options.IPBan = False Then
                QAdd "/ignore " & UserList(i).Username
            End If
        ElseIf (Flag_DB(UserList(i).Username, User) And DB_Flag_K) = DB_Flag_K Then
            If ModVars.bHasOps = True Then
                QAdd "/kick " & UserList(i).Username & Space(1) & "Auto-Kick"
            End If
        End If
    Next i
End Sub

Public Sub Remove_MBL(ByVal Index As Integer) 'Minute_Ban_List
Dim i As Integer
If Index - 1 > UBound(Minute_Ban_List) Then Exit Sub
For i = Index To UBound(Minute_Ban_List) - 1
      Minute_Ban_List(i) = Minute_Ban_List(i + 1)
Next i
ReDim Preserve Minute_Ban_List(UBound(Minute_Ban_List) - 1)
End Sub
